/* Copyright (c) 2008 Nordic Semiconductor. All Rights Reserved.
 *
 * The information contained herein is property of Nordic Semiconductor ASA.
 * Terms and conditions of usage are described in detail in NORDIC
 * SEMICONDUCTOR STANDARD SOFTWARE LICENSE AGREEMENT. 
 *
 * Licensees are granted free, non-transferable use of the information. NO
 * WARRENTY of ANY KIND is provided. This heading must NOT be removed from
 * the file.
 *
 * $LastChangedRevision: 4640 $
 */ 
 
/* This program will generate a latch on condition to pull either the 
RESET pin or PM (Panel Mode) pin low on the SM72442
*/

#include <Nordic\reg24le1.h>
#include "hal_nrf_reg.h"
#include "hal_nrf.h"
#include "radio.h"
#include "application.h"

uint8_t xdata packet[RADIO_MAX_PL];


void send_packet(uint8_t command)
{
	uint8_t data_length;
	
	packet[0] = 0x00;
	packet[1] = data_length = 1;
	packet[DATA_POS] = command;

//	radio_send_packet (packet, data_length+DATA_POS);
	radio_send_packet_noack(packet, data_length+DATA_POS);	 // sending packet without acknowledgement
	while (radio_busy());

}

uint8_t read_packet(void)
{
	uint8_t command, type, data_length, pck_length;
	pck_length = radio_read_data (packet);

	type = packet[0];
	data_length = packet[1];
	command = packet[DATA_POS];

	return command;
}

void radio_irq(void) interrupt RF_READY_INT_VECT  
{
  radio_interrupt();  
}

void main (void)
{
	uint8_t command;


	P0 = 0;
	P0DIR = 0x00;
	W2CON0 = 0x01; //enable the two wire 
	

	RFCKEN = 1;
	RF = 1;
	EA = 1;

		radio_init(0);	//initialize radio as a receiver
		while (true)
		{
			if (radio_data_received())
				{
					command = read_packet();
					switch (command)
					{
						case CMD1:  // reset pin is pulled low and PM pin is tristate 
						RESET = ON;	
						PM = OFF;	
						break;
						
						case CMD2:	// reset pin is tristate and PM pin is tristate (Normal Operation)
						RESET = OFF;
						PM = OFF;
						break;

						case CMD3:	// reset pin is tristate and PM pin is pulled low
						RESET = OFF;
						PM = ON;;
						break;

						default:
						break;
					}	
				}
		}
}

	
